using System.Globalization;
using TMPro;
using UnityEngine;
using static DataStore;

public class FloatAsTextDataBinding : MonoBehaviour
{
    private TextMeshPro tmp;
    public string fieldName;
    private AnimData animData;
    private float lastValue = float.NaN;
    public string format = "D";
    
    private void Start()
    {
        animData = DataStore.GetInstance().GetAnimData(fieldName);
        tmp = GetComponent<TextMeshPro>();
    }
    
    private void Update()
    {
        float f = DataStore.GetInstance().GetFloat(animData);   //TODO: support various number types
        if (f != lastValue)
        {
            lastValue = f;
            tmp.text = ((int)f).ToString(format, CultureInfo.InvariantCulture);    //allocation
        }
    }
}